
Situation

As a Principal Product Manager leading Dell's core e-commerce platform, my team owned a product line that enabled transactions of billions in annual revenue. My direct manager, while supportive, came to me with a directive to reprioritize a significant portion of our roadmap to make space for building a new marketplace engine on top of a legacy product architecture. This directive was based on a top-down mandate from a senior Vice President of the marketplace business unit. My team's roadmap, however, was laser-focused on building a next-gen platform architecture, a long-term strategic bet that would bring substantial benefits across the company for years to come by improving key metrics like conversion rate and customer satisfaction.

Task

The conflict was a fundamental disagreement on strategy: my manager prioritized a top-down, short-term request to build on a legacy system, while my data-driven approach prioritized a long-term, foundational platform that would provide more scalable and lasting value to the company. My task was to convince my manager to maintain our strategic focus on the next-gen platform without creating friction or disrespecting their authority.

Action

To resolve this and align on a path forward, I took a methodical and strategic approach that went beyond simply presenting a different opinion.

1. Framed the Problem with Data and Customer Pain: I did not simply say "no" to the directive. Instead, I came to our meeting armed with a comprehensive analysis. I presented the current technical debt and long-term costs associated with building on the legacy architecture. I also presented data highlighting the specific user pain points and friction points that our next-gen roadmap was designed to address. I quantified the long-term business impact of our planned work, including a projected 6% increase in conversion rate and a 4% improvement in CSAT.  
    
2. Elevated the Discussion to First Principles: I acknowledged the short-term pressure from the senior VP but reframed our discussion around first principles and what was truly right for the business. I argued that if we first fixed the foundational platform—which drove over $100B+ in annual revenue—any new features or engines built on top of it would have a much higher likelihood of success and a lower cost of ownership. I positioned my team’s roadmap as a prerequisite and an enabler for the company's future vision, rather than a roadblock.  
    
3. Proposed a Phased, Collaborative Compromise: To avoid an impasse, I proposed a compromise. I suggested that we maintain the core, high-impact priorities on my roadmap. In parallel, I would personally lead a smaller, parallel initiative to help the marketplace team explore a foundational piece of their engine in a way that would be compatible with our next-gen architecture. This showed that I was a partner, not a blocker, and that I was committed to their success while protecting my team’s long-term vision.
    

Result

My manager was initially surprised by my pushback, but after reviewing the data and my phased proposal, they were ultimately convinced. They championed our next-gen platform and successfully negotiated with the senior VP to push the marketplace engine work to the following quarter. This allowed us to successfully deliver on our key conversion and CSAT goals. My ability to strategically influence my manager not only proved my long-term approach was the right one, but it also strengthened our relationship and demonstrated my commitment to doing what’s right for the business at a strategic level.